
-- **************************************************
-- Provide Moho with the name of this script object
-- **************************************************

ScriptName = "DS_framecounterwfont"

-- **************************************************
-- General information about this script
-- **************************************************

DS_framecounterwfont = {}
function DS_framecounterwfont:Name()
	return "DS Framecounter wfont"
end

function DS_framecounterwfont:Version()
	return "0.5"
end

function DS_framecounterwfont:Description()
	return "Displays current frame number at top or bottom of screen"
end

function DS_framecounterwfont:Creator()
	return "dauid.com"
end

function DS_framecounterwfont:UILabel()
	return("DS Framecounter wfont")
end

-- **************************************************
-- Settings dialogue
-- **************************************************
local DS_Dialog = {}

DS_Dialog.UPDATE = MOHO.MSG_BASE

function DS_Dialog:new(moho)
	local d = LM.GUI.SimpleDialog("Counter Settings", DS_Dialog)
	local l = d:GetLayout()

	d.moho = moho

	

	l:AddChild(LM.GUI.StaticText("Select font for frame counter:"))
	fontList = LM.GUI.TextList(200, 200, self.UPDATE)
	
	l:AddChild(fontList, LM.GUI.ALIGN_FILL)
	moho:FillInFontList(fontList)
	fontList:SetSelItem("Arial Regular")
	
	topPlace = LM.GUI.CheckBox("Place at top instead of bottom")
	l:AddChild(topPlace, LM.GUI.ALIGN_LEFT)
	opaqueBg = LM.GUI.CheckBox("Opaque background")
	l:AddChild(opaqueBg, LM.GUI.ALIGN_LEFT)

	return d
end


function DS_Dialog:OnValidate()
	local b = true
	return b
end

function DS_Dialog:OnOK()
chosenFont=fontList:SelItemLabel()
topPlace=topPlace:Value()
opaqueBg=opaqueBg:Value()
end

-- **************************************************
-- The guts of this script
-- **************************************************

function DS_framecounterwfont:OnMouseDown(moho, mouseEvent)
	self:Run(moho)
end

function DS_framecounterwfont:Run(moho)

local dlog = DS_Dialog:new(moho)
	if (dlog:DoModal() == LM.GUI.MSG_CANCEL) then
		return
	end

curFrame=moho.layer:CurFrame()
moho:SetCurFrame(0)
local counterGroup = (moho:CreateNewLayer(MOHO.LT_GROUP)) -- Create a group layer
counterGroup:SetName("Framecounter")

local bgLayer = (moho:CreateNewLayer(MOHO.LT_VECTOR)) -- Create a bg layer
bgLayer:SetName("Background")
local mesh = moho:Mesh()
	if (mesh == nil) then
		return
	end

	local FillColor = LM.ColorVector:new_local() 
	
	if (opaqueBg==true) then
	FillColor:Set(0.0, 0.0, 0.0, 1) 
	else
	FillColor:Set(0.0, 0.0, 0.0, 0.5) 
	end
	
	self:BuildPolygon(mesh)
	local id=moho:CreateShape(true)
	mesh:Shape(id).fMyStyle.fFillCol:SetValue(0, FillColor:AsColorStruct())
	mesh:Shape(id).fHasOutline = false
	moho:PlaceLayerInGroup(bgLayer, counterGroup)
	local v = LM.Vector3:new_local()

local firstSwitchLayer = (moho:CreateNewLayer(MOHO.LT_SWITCH)) -- Create a switch layer for first number
firstSwitchLayer:SetName("0")
moho:PlaceLayerInGroup(firstSwitchLayer, counterGroup)
--place first switchlayer
v.x=-0.1124
v.y=0
v.z=0
firstSwitchLayer.fTranslation:SetValue(0, v)
	for layers = 0, 9 do

	local counterLayer = (moho:CreateNewLayer(MOHO.LT_VECTOR)) -- Create layers with numbers
	counterLayer:SetName(9-layers)
	moho:InsertText((9-layers), chosenFont, true, false, 0)
	moho:PlaceLayerInGroup(counterLayer, firstSwitchLayer)
	
	
	end
	
local secondSwitchLayer = (moho:CreateNewLayer(MOHO.LT_SWITCH)) -- Create a switch layer for second number
secondSwitchLayer:SetName("00")
moho:PlaceLayerInGroup(secondSwitchLayer, counterGroup)
--place first switchlayer
v.x=-0.1124
v.y=0
v.z=0

	for layers = 0, 9 do

	local counterLayer = (moho:CreateNewLayer(MOHO.LT_VECTOR)) -- Create layers with numbers
	counterLayer:SetName(9-layers)
	moho:InsertText((9-layers), chosenFont, true, false, 0)
	moho:PlaceLayerInGroup(counterLayer, secondSwitchLayer)
	
	
	end
	-- place the second switch layer

v.x=-0.4124
v.y=0
v.z=0
secondSwitchLayer.fTranslation:SetValue(0, v)

local thirdSwitchLayer = (moho:CreateNewLayer(MOHO.LT_SWITCH)) -- Create a switch layer for third number
thirdSwitchLayer:SetName("000")
moho:PlaceLayerInGroup(thirdSwitchLayer, counterGroup)


	for layers = 0, 9 do

	local counterLayer = (moho:CreateNewLayer(MOHO.LT_VECTOR)) -- Create layers with numbers
	counterLayer:SetName(9-layers)
	moho:InsertText((9-layers), chosenFont, true, false, 0)
	moho:PlaceLayerInGroup(counterLayer, thirdSwitchLayer)
	
	
	end
	-- place the second switch layer

v.x=-0.7124
v.y=0
v.z=0
thirdSwitchLayer.fTranslation:SetValue(0, v)


local fourthSwitchLayer = (moho:CreateNewLayer(MOHO.LT_SWITCH)) -- Create a switch layer for fourth number
fourthSwitchLayer:SetName("0000")
moho:PlaceLayerInGroup(fourthSwitchLayer, counterGroup)


	for layers = 0, 9 do

	local counterLayer = (moho:CreateNewLayer(MOHO.LT_VECTOR)) -- Create layers with numbers
	counterLayer:SetName(9-layers)
	moho:InsertText((9-layers), chosenFont, true, false, 0)
	moho:PlaceLayerInGroup(counterLayer, fourthSwitchLayer)
	
	
	end
	-- place the second switch layer

v.x=-1.0124
v.y=0
v.z=0
fourthSwitchLayer.fTranslation:SetValue(0, v)
------------------------------------------------------------------------------------------------------------------


startFrame = moho.document:StartFrame()
endFrame = moho.document:EndFrame()

firstSwitchLayer = moho:LayerAsSwitch(firstSwitchLayer)
secondSwitchLayer = moho:LayerAsSwitch(secondSwitchLayer)
thirdSwitchLayer = moho:LayerAsSwitch(thirdSwitchLayer)
fourthSwitchLayer = moho:LayerAsSwitch(fourthSwitchLayer)

for frames=startFrame, endFrame do --Go through all the frames
	firstSwitchLayer:SetValue(frames, string.sub(frames, -1, -1))
	if (frames>9) then	
	secondSwitchLayer:SetValue(frames, string.sub(frames, -2, -2))
	end
	if (frames>99) then
	thirdSwitchLayer:SetValue(frames, string.sub(frames, -3, -3))
	end
	if (frames>999) then
	fourthSwitchLayer:SetValue(frames, string.sub(frames, -4, -4))
	end
end
counterGroup = moho:LayerAsGroup(counterGroup)
counterGroup:Expand(false)



v.x=0.1124
	if (topPlace==true) then
	v.y=0.6994
	else
	v.y=-0.7897
	end
v.z=0.0

counterGroup.fTranslation:SetValue(0, v)

v.x=0.25
v.y=0.25
v.z=0.25

counterGroup.fScale:SetValue(0, v)

moho:SetSelLayer(counterGroup)
moho.layer:SetImmuneToCamera(true)
moho:SetCurFrame(curFrame)



end

function DS_framecounterwfont:BuildPolygon(mesh) --Function for drawing the background

	local vec = LM.Vector2:new_local()
	mesh:SelectNone()
	
	vec.x=-1.5 --Upper left corner of BG
	vec.y=0.5
	
local pointOne=(mesh:AddLonePoint(vec, 0))
	
	vec.x=0.2 --upper right corner of bg
	vec.y=0.4
local pointTwo=(mesh:AppendPoint(vec, 0))

	vec.x=0.2 --lower right corner of bg
	vec.y=-0.05
local pointThree=(mesh:AppendPoint(vec, 0))

	vec.x=-1.1 --lower left corner
	vec.y=-0.05
local pointFour=(mesh:AppendPoint(vec, 0))

	vec.x=-1.1 --upper left corner
	vec.y=0.4
local pointFive=(mesh:AppendPoint(vec, 0))
	
mesh:WeldPoints(0, 4, 0)

	for i = 0, 3 do
		mesh:Point(i):SetCurvature(MOHO.PEAKED, 0)
	end

	mesh:SelectConnected()
end